/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.lifecycle;

import icyllis.modernui.lifecycle.LifecycleOwner;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.Nonnull;

public class Lifecycle {
    private final WeakReference<LifecycleOwner> mLifecycleOwner;
    private final List<IObserver> mObservers = new ObjectArrayList();
    private State mState = State.INITIALIZED;

    public Lifecycle(@Nonnull LifecycleOwner provider) {
        this.mLifecycleOwner = new WeakReference<LifecycleOwner>(provider);
    }

    public void addObserver(@Nonnull IObserver listener) {
        this.mObservers.add(listener);
    }

    public void removeObserver(@Nonnull IObserver listener) {
        this.mObservers.remove(listener);
    }

    public void setCurrentState(@Nonnull State state) {
        this.moveToState(state);
    }

    public void handleLifecycleEvent(@Nonnull Event event) {
        State next = Lifecycle.getStateAfter(event);
        this.moveToState(next);
    }

    private void moveToState(@Nonnull State state) {
        int i;
        if (this.mState == state) {
            return;
        }
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.mLifecycleOwner.get();
        if (lifecycleOwner == null) {
            throw new IllegalStateException("LifecycleOwner of this Lifecycle is already garbage collected. It is too late to change lifecycle state.");
        }
        while ((i = state.compareTo(this.mState)) != 0) {
            Event event = i < 0 ? this.downEvent(this.mState) : this.upEvent(this.mState);
            for (IObserver l : this.mObservers) {
                l.onLifecycleEvent(lifecycleOwner, event);
            }
        }
    }

    @Nonnull
    private static State getStateAfter(@Nonnull Event event) {
        switch (event) {
            case ON_CREATE: 
            case ON_STOP: {
                return State.CREATED;
            }
            case ON_START: 
            case ON_PAUSE: {
                return State.STARTED;
            }
            case ON_RESUME: {
                return State.RESUMED;
            }
            case ON_DESTROY: {
                return State.DESTROYED;
            }
        }
        throw new IllegalArgumentException("Unexpected event value " + (Object)((Object)event));
    }

    @Nonnull
    private Event downEvent(@Nonnull State state) {
        switch (state) {
            case INITIALIZED: 
            case DESTROYED: {
                throw new IllegalArgumentException();
            }
            case CREATED: {
                this.mState = State.DESTROYED;
                return Event.ON_DESTROY;
            }
            case STARTED: {
                this.mState = State.CREATED;
                return Event.ON_STOP;
            }
            case RESUMED: {
                this.mState = State.STARTED;
                return Event.ON_PAUSE;
            }
        }
        throw new IllegalArgumentException("Unexpected state value " + (Object)((Object)state));
    }

    @Nonnull
    private Event upEvent(@Nonnull State state) {
        switch (state) {
            case INITIALIZED: 
            case DESTROYED: {
                this.mState = State.CREATED;
                return Event.ON_CREATE;
            }
            case CREATED: {
                this.mState = State.STARTED;
                return Event.ON_START;
            }
            case STARTED: {
                this.mState = State.RESUMED;
                return Event.ON_RESUME;
            }
            case RESUMED: {
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException("Unexpected state value " + (Object)((Object)state));
    }

    @Nonnull
    public State getCurrentState() {
        return this.mState;
    }

    public static enum Event {
        ON_CREATE,
        ON_START,
        ON_RESUME,
        ON_PAUSE,
        ON_STOP,
        ON_DESTROY;

    }

    public static enum State {
        DESTROYED,
        INITIALIZED,
        CREATED,
        STARTED,
        RESUMED;


        public boolean isAtLeast(@Nonnull State state) {
            return this.compareTo(state) >= 0;
        }
    }

    @FunctionalInterface
    public static interface IObserver {
        public void onLifecycleEvent(@Nonnull LifecycleOwner var1, Event var2);
    }
}

